#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/ddd/header.h"
#include "levels/bbh/header.h"

extern u8 _ddd_segment_ESegmentRomStart[];
extern u8 _ddd_segment_ESegmentRomEnd[];

const LevelScript level_ddd_entry[] = {
INIT_LEVEL(),
LOAD_MIO0(0x07, _bbh_segment_7SegmentRomStart, _bbh_segment_7SegmentRomEnd),
LOAD_RAW(0x1A, _bbhSegmentRomStart, _bbhSegmentRomEnd),
LOAD_RAW(0x0E, _ddd_segment_ESegmentRomStart, _ddd_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _water_skybox_mio0SegmentRomStart, _water_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group4_mio0SegmentRomStart, _group4_mio0SegmentRomEnd),
LOAD_RAW(12, _group4_geoSegmentRomStart, _group4_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Level Specific Models
LOAD_MODEL_FROM_GEO(MODEL_BBH_HAUNTED_DOOR,           haunted_door_geo),
LOAD_MODEL_FROM_GEO(MODEL_BBH_STAIRCASE_STEP,         geo_bbh_0005B0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TILTING_FLOOR_PLATFORM, geo_bbh_0005C8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM,      geo_bbh_0005E0),
LOAD_MODEL_FROM_GEO(MODEL_BBH_TUMBLING_PLATFORM_PART, geo_bbh_0005F8),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MOVING_BOOKSHELF,       geo_bbh_000610),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MESH_ELEVATOR,          geo_bbh_000628),
LOAD_MODEL_FROM_GEO(MODEL_BBH_MERRY_GO_ROUND,         geo_bbh_000640),
LOAD_MODEL_FROM_GEO(MODEL_BBH_WOODEN_TOMB,            geo_bbh_000658),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_GEO(84, 0x05008d14),
// LOAD_MODEL_FROM_DL(87, 0x05013cb8, 4),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_5),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_ddd_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_ddd_1_[] = {
AREA(1, Geo_ddd_1_0x15c59b0),
TERRAIN(col_ddd_1_0xe02f140),
SET_BACKGROUND_MUSIC(0, 44),
TERRAIN_TYPE(3),
JUMP_LINK(local_objects_ddd_1_),
JUMP_LINK(local_warps_ddd_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_ddd_1_[] = {
OBJECT_WITH_ACTS(0, 1278, 6454, -6242, 0, 98, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 3211, -4116, 3905, 0, 345, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(120, -697, -4044, 2024, 0, 206, 0, 0x0,  bhvRecoveryHeart, 31),
OBJECT_WITH_ACTS(124, -3530, 1671, -4815, 0, 203, 0, 0x440000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(88, -656, -169, -6324, 0, 0, 0, 0x0,  bhvClamShell, 31),
OBJECT_WITH_ACTS(88, -4270, -2403, 4581, 353, 0, 12, 0x0,  bhvClamShell, 31),
OBJECT_WITH_ACTS(88, 2744, -2248, 4359, 333, 90, 14, 0x0,  bhvClamShell, 31),
OBJECT_WITH_ACTS(88, -1799, -2916, 4718, 1, 64, 21, 0x0,  bhvClamShell, 31),
OBJECT_WITH_ACTS(215, -623, -219, -6320, 0, 87, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4202, -2463, 4606, 0, 95, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -1773, -3000, 4660, 0, 153, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4742, -1211, -5464, 0, 87, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 2742, -2310, 4313, 0, 204, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -4208, -1926, -7743, 0, 87, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -2181, -1554, -4703, 0, 87, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 362, -2934, -3123, 0, 87, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(0, -4228, -3589, -4601, 0, 90, 0, 0x1000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(137, -2181, 2074, 4804, 0, 0, 0, 0x10000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, -763, 5062, 3758, 0, 0, 0, 0x2000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -4306, 2082, 4643, 0, 155, 0, 0x5000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, -3629, 1709, -7594, 0, 98, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, -3619, 1709, -7592, 0, 98, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, -3202, -169, -7065, 0, 87, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, -3198, -169, -7070, 0, 87, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 1371, -2369, 1860, 0, 179, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, 1346, -2369, 1846, 0, 179, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, -3740, -689, 4820, 0, 180, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, -3739, -683, 4838, 0, 187, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, -3747, -4429, -2226, 0, 85, 0, 0x0,  Bhv_Custom_0x130058c8, 31),
OBJECT_WITH_ACTS(0, -3748, -4429, -2222, 0, 87, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 2323, 1771, 3630, 0, 171, 0, 0x3000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(101, 6264, 3533, 55, 0, 90, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(101, 6683, 1271, 2755, 0, 90, 0, 0x0,  bhvScuttlebug, 31),
OBJECT_WITH_ACTS(192, 5648, 4912, 4668, 0, 0, 0, 0x0,  bhvGoomba, 31),
OBJECT_WITH_ACTS(0, 380, 1271, -2486, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(223, 2594, 1271, 2481, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(194, 8368, 4382, 1797, 0, 0, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(180, -3900, 4352, 1327, 0, 32, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -3297, 5102, -901, 0, 71, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(137, 5309, 5239, 4629, 0, 0, 0, 0x50000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 5233, 5359, -3879, 0, 27, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -3072, 5233, -824, 0, 60, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -1430, 2346, -7971, 0, 0, 0, 0x40000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, -190, 1271, -2986, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(194, -3185, -4169, -2405, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(194, -384, 1470, -5244, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(0, -3070, 4822, -854, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, -4410, 1480, -3530, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(137, -1988, 5604, -4507, 0, 359, 0, 0x10000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, -1973, 5604, -4968, 0, 359, 0, 0x20000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(0, -1554, 5257, -4732, 0, 54, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(180, -9, 5676, -3723, 0, 310, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -2460, 3762, 1479, 0, 67, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(194, 5467, 5058, -7154, 0, 67, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(0, 674, -1819, -3868, 0, 354, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 1365, -2109, 1860, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 6517, 2819, 3929, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 1079, 1271, -1105, 0, 31, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -4474, 2111, -6189, 0, 47, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2421, -1620, -648, 0, 25, 0, 0x130000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -1430, -1894, 689, 0, 300, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 337, -2392, 2622, 0, 309, 0, 0x130000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(88, -4353, -2349, 2324, 8, 7, 348, 0x0,  bhvClamShell, 31),
OBJECT_WITH_ACTS(88, -1855, -2713, 3087, 8, 1, 356, 0x0,  bhvClamShell, 31),
OBJECT_WITH_ACTS(194, 1063, -4122, -4511, 0, 0, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(194, -3681, -2226, -7279, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(194, -2992, -156, -7023, 0, 0, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(194, 440, -4260, 2509, 0, 0, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(188, 3754, 5430, -7157, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 2850, 5430, -7466, 0, 0, 0, 0x0,  bhvBobomb, 23),
OBJECT_WITH_ACTS(188, 7327, 3925, -2304, 0, 0, 0, 0x0,  bhvBobomb, 23),
OBJECT_WITH_ACTS(188, -2897, 1271, 2389, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(194, -3233, 2207, -7609, 0, 4, 0, 0x0,  bhvCirclingAmp, 31),
OBJECT_WITH_ACTS(188, -449, 1671, 687, 0, 4, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(188, 634, 1271, 647, 0, 4, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(194, -1566, 2785, 1716, 0, 4, 0, 0x0,  bhvHomingAmp, 31),
OBJECT_WITH_ACTS(217, -2327, 1271, 1678, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, -2635, 1271, 1678, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, -2635, 1271, 1371, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, -2634, 1271, 1985, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(217, -2941, 1271, 1678, 0, 0, 0, 0x0,  bhvPushableMetalBox, 31),
OBJECT_WITH_ACTS(122, -2637, 1404, 1665, 0, 0, 0, 0x4000000,  bhvStar, 31),
OBJECT_WITH_ACTS(137, 827, 5824, -6878, 0, 28, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(140, 1414, 3432, 165, 0, 49, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, 1268, 3482, 45, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 1013, 3482, -75, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 675, 3482, -56, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, 291, 3482, -28, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -92, 3482, -177, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -439, 3482, -380, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -795, 3482, -271, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -1185, 3482, -132, 0, 49, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(223, 1299, 1271, -1728, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(120, 109, -1269, -4565, 0, 0, 0, 0x0,  bhvRecoveryHeart, 31),
OBJECT_WITH_ACTS(120, -372, -2789, 3802, 0, 0, 0, 0x0,  bhvRecoveryHeart, 31),
RETURN()
};

const LevelScript local_warps_ddd_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 2, 43, 0),
WARP_NODE(241, 6, 2, 53, 0),
RETURN()
};
